using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SMAT_CE.Data
{
    public partial class uc_ModelDataA : ucBase
    {
        public uc_ModelDataA()
        {
            InitializeComponent();
            #region Language added by Yangwenwei
            if (LanguageOld.CurrentLanguage() == "Ch")
            {
                //Language.GetLanguagePath();
                Dictionary<string, string> dic = new Dictionary<string, string>();
                LanguageOld.SetDicFromXml(this, dic);
                LanguageOld.ChangeLanguage(dic, this);
            }
            #endregion
        }

        private void uc_ModelDataA_Load(object sender, EventArgs e)
        {
            try
            {
                cboPointGridA.Items.Add("1x1");
                cboPointGridA.Items.Add("3x3");
                cboPointGridA.Items.Add("5x5");
                cboPointGridA.Items.Add("7x7");

                cboSpatialGridA.Items.Add("1x1");
                cboSpatialGridA.Items.Add("3x3");
                cboSpatialGridA.Items.Add("5x5");
                cboSpatialGridA.Items.Add("7x7");

            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblTemporalAdjustment_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_1_7_model_data_options.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
    }
}
